<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Berita;
use App\Models\Profil;
use App\Models\RefSK;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;
use RealRashid\SweetAlert\Facades\Alert;

class BeritaController extends Controller
{
    public function index(){
        $level = Auth::user()->level;
        $profil = Profil::where('pt_id', 1)->first();
        $datas = Berita::all();
        $refsks = RefSK::all();
        return view('admin.berita.index',[
            'level' => $level,
            'profil' => $profil,
            'datas' => $datas,
            'refsks' => $refsks,
        ])->with('tittle', 'Pengelolaan Berita');
    }

    public function add(){
        $level = Auth::user()->level;
        $profil = Profil::where('pt_id', 1)->first();
        $refsks = RefSK::all();
        return view('admin.berita.add',[
            'level' => $level,
            'profil' => $profil,
            'refsks' => $refsks,
        ])->with('tittle', 'Tambah Berita');
    }

    public function store(Request $request){
        $request->validate([
            'judul'      => 'required',
            'isi_berita'      => 'required',
        ]);

        $input = $request->all();
        // $input['judul'] = strtoupper($request->judul);
        if (empty($request->foto)) {
            $nama_file = NULL;
        } else {
            $image = $request->file('foto');
            $nama_file = date('dmYHis').'.'.$image->getClientOriginalExtension();
            $tujuan_upload = public_path('../public/assets/images/berita');
            $image->move($tujuan_upload,$nama_file);
        }
        $input['foto'] = $nama_file;
        $input['slug_judul'] = Str::slug($request->judul, '-');

        $simpan = Berita::create($input);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-berita-index');
    }

    public function edit($id){
        $level = Auth::user()->level;
        $profil = Profil::where('pt_id', 1)->first();
        $data = Berita::whereId($id)->first();
        $refsks = RefSK::all();
        return view('admin.berita.edit',[
            'level' => $level,
            'profil' => $profil,
            'data' => $data,
            'refsks' => $refsks,
        ])->with('tittle', 'Edit Berita');
    }

    public function update(Request $request){
        $request->validate([
            'judul'      => 'required',
            'isi_berita'      => 'required',
        ]);

        $data = Berita::where('id', $request->id)->first();

        if (empty($request->foto)) {
            $nama_file = $data->foto;
        } else {
            $image = $request->file('foto');
            $nama_file = date('dmYHis').'.'.$image->getClientOriginalExtension();
            $tujuan_upload = public_path('../public/assets/images/berita');
            $image->move($tujuan_upload,$nama_file);

            $lokasi = $tujuan_upload.'/'.$data->foto;
            if(File::exists($lokasi)) {
                File::delete($lokasi);
            }
        }

        $simpan = Berita::where('id', $request->id)->update([
            'judul' => $request->judul,
            'slug_judul' => Str::slug($request->judul, '-'),
            'isi_berita' => $request->isi_berita,
            'sumber' => $request->sumber,
            'foto' => $nama_file,
            // 'tanggal' => $request->tanggal,
        ]);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-berita-index');
    }

    public function delete($id){
        $data = Berita::where('id', $id)->first();
        $direktori = public_path('../public/assets/images/berita');
        $lokasi = $direktori.'/'.$data->foto;
        if(File::exists($lokasi)) {
            File::delete($lokasi);
        }
        $eksekusi = Berita::where('id', $id)->delete();

        if ($eksekusi) {
            Alert::success('Berhasil', 'Data Telah Dihapus');
        } else {
            Alert::error('Gagal', 'Data Tidak Dihapus');
        }

        return redirect()->route('admin-berita-index');
    }
}
