@if ($paginator->hasPages())
<ul class="pagination justify-content-center">
    @if ($paginator->onFirstPage())
        <li class="page-item disabled"><a href="{{ $paginator->previousPageUrl() }}" class="page-link" rel="prev">← Previous</a></li>
    @else
        <li class="page-item"><a href="{{ $paginator->previousPageUrl() }}" class="page-link" rel="prev">← Previous</a></li>
    @endif
    @foreach ($elements as $element)
        @if (is_string($element))
            <li class="page-item disabled"><span>{{ $element }}</span></li>
        @endif
        @if (is_array($element))
            @foreach ($element as $page => $url)
                @if ($page == $paginator->currentPage())
                    <li class="page-item active my-active"><a href="{{ $url }}" class="page-link">{{ $page }}</a></li>
                @else
                    <li class="page-item"><a href="{{ $url }}" class="page-link">{{ $page }}</a></li>
                @endif
            @endforeach
        @endif
    @endforeach
    @if ($paginator->hasMorePages())
        <li class="page-item"><a href="{{ $paginator->nextPageUrl() }}" class="page-link" rel="next">Next →</a></li>
    @else
        <li class="page-item disabled"><a href="{{ $paginator->nextPageUrl() }}" class="page-link" rel="next">Next →</a></li>
    @endif
</ul>
@endif 