<?php
    use App\Models\Sosmed;
?>

<?php $__env->startSection('css'); ?>
<link href="https://cdn.datatables.net/1.13.1/css/dataTables.bootstrap5.min.css" rel="stylesheet" type="text/css" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!--begin::Toolbar-->
<div class="toolbar mt-2" id="kt_toolbar">
    <!--begin::Container-->
    <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
        <!--begin::Page title-->
        <div data-kt-swapper="true" data-kt-swapper-mode="prepend" data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}" class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
            <!--begin::Title-->
            <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1"><?php echo e($tittle); ?></h1>
            <!--end::Title-->
            <!--begin::Separator-->
            <span class="h-20px border-gray-300 border-start mx-4"></span>
            <!--end::Separator-->
            <!--begin::Breadcrumb-->
            <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-7 my-1">
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted">
                    <a href="<?php echo e(route('admin-dashboard')); ?>" class="text-muted text-hover-primary">Beranda</a>
                </li>
                <li class="breadcrumb-item">
                    <span class="bullet bg-gray-300 w-5px h-2px"></span>
                </li>
                <li class="breadcrumb-item text-muted"><?php echo e($tittle); ?></li>
                <!--end::Item-->
            </ul>
            <!--end::Breadcrumb-->
        </div>
        <!--end::Page title-->
    </div>
</div>
<!--begin::Post-->
<div class="post d-flex flex-column-fluid mt-0">
    <!--begin::Container-->
    <div class="container">
        <!--begin::Pricing card-->
        <?php if(count($errors) > 0): ?>
        <div class="alert alert-danger">
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
        <?php endif; ?>
        <div class="card mb-5 bg-warning">
            <div class="card-header">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bolder text-dark">Form Tambah <?php echo e($tittle); ?></span>
                </h3>
            </div>
            <form type="POST" action="<?php echo e(route('admin-visimisi-store')); ?>" method="post" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <!--begin::Card body-->
            <div class="card-body p-lg-5">
                <div class="row">
                    <div class="col-md-2">
                        <div class="d-flex flex-column mb-7 fv-row">
                            <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                <span class="required">Pilih Jenis</span>
                            </label>
                            <?php
                                $jeniss=['Visi','Misi'];
                            ?>
                            <select name="jenis" id="jenis" class="form-control form-select<?php echo e($errors->has('jenis') ? ' is-invalid' : ''); ?>">
                                <?php $__currentLoopData = $jeniss; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $jenis): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($jenis); ?>"><?php echo e($jenis); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php if($errors->has('jenis')): ?>
                                <span class="invalid-feedback"><?php echo e($errors->first('jenis')); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="d-flex flex-column mb-7 fv-row">
                            <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                <span class="required">Periode Tahun</span>
                            </label>
                            <input type="text" name="periode" id="periode" class="form-control<?php echo e($errors->has('periode') ? ' is-invalid' : ''); ?>" placeholder="Contoh: 2019-2024">
                            <?php if($errors->has('periode')): ?>
                                <span class="invalid-feedback"><?php echo e($errors->first('periode')); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-md-8">
                        <div class="d-flex flex-column mb-7 fv-row">
                            <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                <span class="required">Poin Visi Misi</span>
                            </label>
                            <textarea name="isi_visimisi" id="isi_visimisi" class="form-control<?php echo e($errors->has('isi_visimisi') ? ' is-invalid' : ''); ?>" placeholder="Masukan disini!" rows="2"></textarea>
                            <?php if($errors->has('isi_visimisi')): ?>
                                <span class="invalid-feedback"><?php echo e($errors->first('isi_visimisi')); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-footer text-end bg-warning">
                <button type="reset" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                <button type="submit" class="btn btn-primary">
                    <span class="indicator-label">Simpan</span>
                </button>
            </div>
            </form>
        </div>
        <div class="card">
            <div class="card-header bg-secondary">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bolder text-dark">List <?php echo e($tittle); ?></span>
                </h3>
                <div class="card-toolbar">
                    
                </div>
            </div>
            <!--begin::Card body-->
            <div class="card-body p-lg-5">
                <table id="datatable" class="table table-striped table-row-bordered gy-4 gs-7 border rounded">
                    <thead>
                        <tr class="fw-bolder bg-secondary fs-6 text-gray-800 px-7">
                            <th width="7%" class="align-middle">No</th>
                            <th class="align-middle text-center" width="10%">Opsi</th>
                            <th class="align-middle text-center" width="15%">Periode</th>
                            <th class="align-middle text-center" width="15%">Jenis Visi Misi</th>
                            <th class="align-middle">Poin Visi Misi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="align-middle"><?php echo e($loop->iteration); ?></td>
                                <td class="align-middle">
                                    <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#update-<?php echo e($data->id); ?>" class="btn btn-icon btn-sm btn-outline btn-outline-info text-hover-white">
                                        <i class="bi bi-pencil text-info fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Update"></i>
                                    </a>
                                    <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#delete-<?php echo e($data->id); ?>" class="btn btn-icon btn-sm btn-outline btn-outline-danger text-hover-white">
                                        <i class="bi bi-trash text-danger fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Hapus"></i>
                                    </a>
                                </td>
                                <td class="align-middle text-center"><?php echo e($data->periode); ?></td>
                                <td class="align-middle text-center"><?php echo e(strtoupper($data->jenis)); ?></td>
                                <td class="align-middle"><?php echo e($data->isi_visimisi); ?></td>
                            </tr>
                            <?php echo $__env->make('admin.visimisi.item.modal-update', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php echo $__env->make('admin.visimisi.item.modal-delete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('admin.sosmed.item.modal-store', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script src="https://code.jquery.com/jquery-3.5.1.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/dataTables.bootstrap5.min.js"></script>
<script>
    $(document).ready(function () {
        $('#datatable').DataTable({
            // "lengthMenu": [ [25, 50, 100, -1], [25, 50, 100, "All"] ],
            // "iDisplayLength": 25
        });
    });

    
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\desaid\resources\views/admin/visimisi/index.blade.php ENDPATH**/ ?>