<div class="modal fade" id="update-<?php echo e($data->id); ?>" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-dialog-centered mw-650px">
        <!--begin::Modal content-->
        <div class="modal-content">
            <!--begin::Modal header-->
            <div class="modal-header">
                <!--begin::Modal title-->
                <h2>Form Edit Sosmed</h2>
                <!--end::Modal title-->
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                    <span class="svg-icon svg-icon-1">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                            <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="black" />
                            <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="black" />
                        </svg>
                    </span>
                    <!--end::Svg Icon-->
                </div>
                <!--end::Close-->
            </div>
            <!--end::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y mx-5 mx-xl-15 my-7">
                <?php if(count($errors) > 0): ?>
                <div class="alert alert-danger">
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <?php endif; ?>
                <!--begin::Form-->
                <form type="POST" action="<?php echo e(route('admin-sosmed-update', ['id' => $data->id])); ?>" method="post" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <!--begin::Input group-->
                    <div class="d-flex flex-column mb-4 fv-row">
                        <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                            <span class="required">Nama Pengguna</span>
                        </label>
                        <input type="text" class="form-control<?php echo e($errors->has('name') ? ' is-invalid' : ''); ?>" id="name" name="name" value="<?php echo e($data->name); ?>"/>
                        <?php if($errors->has('name')): ?>
                            <span class="invalid-feedback"><?php echo e($errors->first('name')); ?></span>
                        <?php endif; ?>
                    </div>
                    <div class="d-flex flex-column mb-4 fv-row">
                        <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                            <span class="required">Alamat Email</span>
                        </label>
                        <input type="email" name="email" id="email" class="form-control<?php echo e($errors->has('email') ? ' is-invalid' : ''); ?>" value="<?php echo e($data->email); ?>">
                        <?php if($errors->has('email')): ?>
                            <span class="invalid-feedback"><?php echo e($errors->first('email')); ?></span>
                        <?php endif; ?>
                    </div>
                    <div class="d-flex flex-column mb-4 fv-row">
                        <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                            <span class="required">Level Pengguna</span>
                        </label>
                        <?php
                            $levels = ['admin','user'];
                        ?>
                        <select name="level" id="level" class="form-control form-select<?php echo e($errors->has('level') ? ' is-invalid' : ''); ?>">
                            <?php $__currentLoopData = $levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($level); ?>" <?php echo e($data->level==$level ? 'selected' : ''); ?>><?php echo e(ucfirst($level)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php if($errors->has('level')): ?>
                            <span class="invalid-feedback"><?php echo e($errors->first('level')); ?></span>
                        <?php endif; ?>
                    </div>
                    <div class="d-flex flex-column mb-4 fv-row">
                        <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                            <span class="required">Username</span>
                        </label>
                        <input type="text" name="username" id="username" class="form-control<?php echo e($errors->has('username') ? ' is-invalid' : ''); ?>" value="<?php echo e($data->username); ?>">
                        <?php if($errors->has('username')): ?>
                            <span class="invalid-feedback"><?php echo e($errors->first('username')); ?></span>
                        <?php endif; ?>
                    </div>
                    <div class="d-flex flex-column mb-4 fv-row">
                        <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                            <span class="required">Status Pengguna</span>
                        </label>
                        <?php
                            $statuss = ['Aktif','Tidak Aktif'];
                        ?>
                        <select name="status" id="status" class="form-control form-select<?php echo e($errors->has('status') ? ' is-invalid' : ''); ?>">
                            <?php $__currentLoopData = $statuss; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($status); ?>" <?php echo e($data->status==$status ? 'selected' : ''); ?>><?php echo e($status); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php if($errors->has('status')): ?>
                            <span class="invalid-feedback"><?php echo e($errors->first('status')); ?></span>
                        <?php endif; ?>
                    </div><hr>
                    <!--end::Input group-->
                    <!--begin::Actions-->
                    <div class="text-center pt-5">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" class="btn btn-primary">
                            <span class="indicator-label">Simpan</span>
                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end::Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div><?php /**PATH C:\xampp\htdocs\desaid\resources\views/admin/pengguna/item/modal-update.blade.php ENDPATH**/ ?>