<!DOCTYPE html>
<!--
Author: Yana Herdiana
Product Name: Newspaper
Website: http://www.example.com
Contact: mycontact@example.com
-->
<html lang="en">
	<!--begin::Head-->
	<head><base href="">
		<title><?php echo e($tittle); ?> - <?php echo e($profil->nama); ?></title>
		<meta charset="utf-8" />
		<meta name="description" content="<?php echo e($profil->nama); ?>" />
		<meta name="keywords" content="berita, artikel, news, article, articles, hot news, berita terbaru, seputar pangandaran, seputar indonesia, indonesia, bandung, jakarta, ciamis, tasik, banjar, pangandaran, pantai pangandaran, pantai, batuhiu, batukaras" />
		<meta name="viewport" content="width=device-width, initial-scale=1" />
		<meta property="og:locale" content="id_ID" />
		<meta property="og:type" content="article" />
		<meta property="og:title" content="<?php echo e($profil->nama); ?> dan artikel" />
		<meta property="og:url" content="https://example.com" />
		<meta property="og:site_name" content="<?php echo e($profil->nama); ?>" />
		<link rel="shortcut icon" href="<?php echo e(asset('assets/media/logos/favicon.ico')); ?>" />
		<!--begin::Fonts-->
		<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" />
		<!--end::Fonts-->
		<!--begin::Global Stylesheets Bundle(used by all pages)-->
		<link href="<?php echo e(asset('assets/plugins/global/plugins.bundle.css')); ?>" rel="stylesheet" type="text/css" />
		<link href="<?php echo e(asset('assets/css/style.bundle.css')); ?>" rel="stylesheet" type="text/css" />
		<!--end::Global Stylesheets Bundle-->
		<?php echo $__env->yieldContent('css'); ?>
	</head>
	<!--end::Head-->
	<!--begin::Body-->
	<body id="kt_body" class="header-fixed header-tablet-and-mobile-fixed toolbar-enabled toolbar-fixed aside-enabled aside-fixed" style="--kt-toolbar-height:55px;--kt-toolbar-height-tablet-and-mobile:55px">
		<?php echo $__env->make('sweetalert::alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		<!--begin::Main-->
		<!--begin::Root-->
		<div class="d-flex flex-column flex-root">
			<!--begin::Page-->
			<div class="page d-flex flex-row flex-column-fluid">
				<!--begin::Aside-->
				<?php echo $__env->make('admin.layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
				<!--end::Aside-->
				<!--begin::Wrapper-->
				<div class="wrapper d-flex flex-column flex-row-fluid" id="kt_wrapper">
					<!--begin::Header-->
					<?php echo $__env->make('admin.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
					<!--end::Header-->
					<!--begin::Content-->
                    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
                        <?php echo $__env->yieldContent('content'); ?>
                    </div>
					<!--end::Content-->
					<!--begin::Footer-->
					<?php echo $__env->make('admin.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
					<!--end::Footer-->
				</div>
				<!--end::Wrapper-->
			</div>
			<!--end::Page-->
		</div>
		<!--end::Root-->

		<!--begin::Javascript-->
		<script>var hostUrl = "assets/";</script>
		<!--begin::Global Javascript Bundle(used by all pages)-->
		<script src="<?php echo e(asset('assets/plugins/global/plugins.bundle.js')); ?>"></script>
		<script src="<?php echo e(asset('assets/js/scripts.bundle.js')); ?>"></script>
		<!--end::Global Javascript Bundle-->
		<!--begin::Page Custom Javascript(used by this page)-->
		<script src="<?php echo e(asset('assets/js/custom/widgets.js')); ?>"></script>
		<script src="<?php echo e(asset('assets/js/custom/apps/chat/chat.js')); ?>"></script>
		<script src="<?php echo e(asset('assets/js/custom/modals/create-app.js')); ?>"></script>
		<script src="<?php echo e(asset('assets/js/custom/modals/upgrade-plan.js')); ?>"></script>
		<!--end::Page Custom Javascript-->

		<?php echo $__env->yieldContent('js'); ?>
		<!--end::Javascript-->
	</body>
	<!--end::Body-->
</html><?php /**PATH C:\xampp\htdocs\cv\resources\views/admin/layouts/master.blade.php ENDPATH**/ ?>