<!-- /*
* Template Name: Property
* Template Author: Untree.co
* Template URI: https://untree.co/
* License: https://creativecommons.org/licenses/by/3.0/
*/ -->
<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta name="author" content="{{ $profil?->nama }}" />
    <link rel="shortcut icon" href="{{ asset('assets/media/logos/favicon.ico') }}" />

    <meta name="description" content="{{ $profil?->tentang }}" />
    <meta name="keywords" content="pt, cv, properti, property, pangandaran, parigi, batukaras, ciamis, banjar, pantai" />

    <title>{{ $tittle }} - {{ $profil?->nama }}</title>
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Work+Sans:wght@400;500;600;700&display=swap" rel="stylesheet"/>

    <link rel="stylesheet" href="{{ asset('/guest/fonts/icomoon/style.css') }}" />
    <link rel="stylesheet" href="{{ asset('/guest/fonts/flaticon/font/flaticon.css') }}" />

    <link rel="stylesheet" href="{{ asset('/guest/css/tiny-slider.css') }}" />
    <link rel="stylesheet" href="{{ asset('/guest/css/aos.css') }}" />
    <link rel="stylesheet" href="{{ asset('/guest/css/style.css') }}" />
    @yield('css')
  </head>
  <body>
    <div class="site-mobile-menu site-navbar-target">
      <div class="site-mobile-menu-header">
        <div class="site-mobile-menu-close">
          <span class="icofont-close js-menu-toggle"></span>
        </div>
      </div>
      <div class="site-mobile-menu-body"></div>
    </div>
    @include('guest.item.navbar')
    @yield('content')
    @include('guest.item.footer')
    <!-- /.site-footer -->

    <!-- Preloader -->
    <div id="overlayer"></div>
    <div class="loader">
      <div class="spinner-border" role="status">
        <span class="visually-hidden">Loading...</span>
      </div>
    </div>

    <script src="{{ asset('/guest/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('/guest/js/tiny-slider.js') }}"></script>
    <script src="{{ asset('/guest/js/aos.js') }}"></script>
    <script src="{{ asset('/guest/js/navbar.js') }}"></script>
    <script src="{{ asset('/guest/js/counter.j') }}s"></script>
    <script src="{{ asset('/guest/js/custom.js/') }}"></script>
    @yield('js')
  </body>
</html>
