<?php

namespace App\Http\Controllers\Admin\SK;

use App\Http\Controllers\Controller;
use App\Models\Profil;
use App\Models\RefSK;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;
use RealRashid\SweetAlert\Facades\Alert;

class RefSKController extends Controller
{
    public function index(){
        $level = Auth::user()->level;
        $profil = Profil::where('pt_id', 1)->first();
        $datas = RefSK::all();
        $refsks = RefSK::all();
        return view('admin.sk.index',[
            'level' => $level,
            'profil' => $profil,
            'datas' => $datas,
            'refsks' => $refsks,
        ])->with('tittle', 'Pengelolaan Ref. Surat Keterangan');
    }

    public function add(){
        $level = Auth::user()->level;
        $profil = Profil::where('pt_id', 1)->first();
        $refsks = RefSK::all();
        return view('admin.sk.add',[
            'level' => $level,
            'profil' => $profil,
            'refsks' => $refsks,
        ])->with('tittle', 'Tambah Ref. SK');
    }

    public function store(Request $request){
        $request->validate([
            'nama'      => 'required|string|max:255',
            'format'      => 'required',
        ]);

        $input = $request->all();
        $input['nama'] = strtoupper($request->nama);
        if (empty($request->format)) {
            $nama_file = NULL;
        } else {
            $image = $request->file('format');
            $nama_file = Str::slug($request->nama, '-').'.'.$image->getClientOriginalExtension();
            $tujuan_upload = public_path('../public/assets/images/sk');
            $image->move($tujuan_upload,$nama_file);
        }
        $input['format'] = $nama_file;
        $input['slug_nama'] = Str::slug($request->nama, '-');

        $simpan = RefSK::create($input);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-sk-index');
    }
}
