<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Profil;
use App\Models\RefSK;
use App\Models\Slider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use RealRashid\SweetAlert\Facades\Alert;

class SliderController extends Controller
{
    public function index(){
        $level = Auth::user()->level;
        $datas = Slider::all();
        $profil = Profil::where('pt_id', 1)->first();
        $refsks = RefSK::all();
        return view('admin.slider.index',[
            'datas' => $datas,
            'level' => $level,
            'profil' => $profil,
            'refsks' => $refsks,
        ])->with('tittle', 'Pengelolaan Slider');
    }

    public function store(Request $request){
        $request->validate([
            'nama'      => 'required',
        ]);

        $input = $request->all();
        $input['nama'] = strtoupper($request->nama);
        if (empty($request->foto)) {
            $nama_file = NULL;
        } else {
            $image = $request->file('foto');
            $nama_file = date('dmYHis').'.'.$image->getClientOriginalExtension();
            $tujuan_upload = public_path('../public/assets/images/slider');
            $image->move($tujuan_upload,$nama_file);
        }
        $input['foto'] = $nama_file;
        $input['status'] = 'aktif';

        $simpan = Slider::create($input);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-slider-index');
    }

    public function update(Request $request, $id){
        $request->validate([
            'nama'      => 'required',
        ]);

        $data = Slider::where('id', $id)->first();

        if (empty($request->foto)) {
            $nama_file = $data->foto;
        } else {
            $image = $request->file('foto');
            $nama_file = date('dmYHis').'.'.$image->getClientOriginalExtension();
            $tujuan_upload = public_path('../public/assets/images/slider');
            $image->move($tujuan_upload,$nama_file);

            $lokasi = $tujuan_upload.'/'.$data->foto;
            if(File::exists($lokasi)) {
                File::delete($lokasi);
            }
        }

        $simpan = Slider::where('id', $request->id)->update([
            'nama' => $request->nama,
            'foto' => $nama_file,
        ]);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-slider-index');
    }

    public function delete($id) {
        $data = Slider::where('id', $id)->first();
        $direktori = public_path('../public/assets/images/slider');
        $lokasi = $direktori.'/'.$data->foto;
        if(File::exists($lokasi)) {
            File::delete($lokasi);
        }
        $hapusdata = Slider::where('id', $id)->delete();

        if ($hapusdata) {
            Alert::success('Berhasil', 'Data Telah Dihapus');
        } else {
            Alert::error('Gagal', 'Data Tidak Dihapus');
        }

        return redirect()->route('admin-slider-index');
    }

    public function status(Request $request, $id){
        $simpan = Slider::where('id', $id)->update([
            'status' => $request->status,
        ]);
        return redirect()->route('admin-slider-index');
    }
}
