<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Profil;
use App\Models\RefSK;
use App\Models\Visimisi;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Str;

class VisimisiController extends Controller
{
    public function index(){
        $level = Auth::user()->level;
        $profil = Profil::where('pt_id', 1)->first();
        $datas = Visimisi::all();
        $refsks = RefSK::all();
        return view('admin.visimisi.index',[
            'datas' => $datas,
            'level' => $level,
            'profil' => $profil,
            'refsks' => $refsks,
        ])->with('tittle', 'Visi Misi');
    }

    public function store(Request $request){
        $request->validate([
            'jenis'      => 'required',
            'periode'      => 'required|string|max:20',
            'isi_visimisi'      => 'required|string|max:255',
        ]);

        $input = $request->all();
        $simpan = Visimisi::create($input);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-visimisi-index');
    }

    public function update(Request $request, $id){
        $request->validate([
            'jenis'      => 'required',
            'periode'      => 'required|string|max:20',
            'isi_visimisi'      => 'required|string|max:255',
        ]);

        $simpan = Visimisi::where('id', $id)->update([
            'jenis' => strtoupper($request->jenis),
            'periode' => strtoupper($request->periode),
            'isi_visimisi' => $request->isi_visimisi,
        ]);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-visimisi-index');
    }

    public function delete($id) {
        $hapusdata = Visimisi::where('id', $id)->delete();

        if ($hapusdata) {
            Alert::success('Berhasil', 'Data Telah Dihapus');
        } else {
            Alert::error('Gagal', 'Data Tidak Dihapus');
        }

        return redirect()->route('admin-visimisi-index');
    }
}
