@php
    use App\Models\User;
@endphp
@extends('admin.layouts.master')
@section('css')
<link href="https://cdn.datatables.net/1.13.1/css/dataTables.bootstrap5.min.css" rel="stylesheet" type="text/css" />
@endsection
@section('content')
<!--begin::Toolbar-->
<div class="toolbar mt-2" id="kt_toolbar">
    <!--begin::Container-->
    <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
        <!--begin::Page title-->
        <div data-kt-swapper="true" data-kt-swapper-mode="prepend" data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}" class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
            <!--begin::Title-->
            <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1">{{ $tittle }}</h1>
            <!--end::Title-->
            <!--begin::Separator-->
            <span class="h-20px border-gray-300 border-start mx-4"></span>
            <!--end::Separator-->
            <!--begin::Breadcrumb-->
            <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-7 my-1">
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted">
                    <a href="{{ route('admin-dashboard') }}" class="text-muted text-hover-primary">{{ $tittle }}</a>
                </li>
                <li class="breadcrumb-item">
                    <span class="bullet bg-gray-300 w-5px h-2px"></span>
                </li>
                <li class="breadcrumb-item text-muted">Pengguna</li>
                <!--end::Item-->
            </ul>
            <!--end::Breadcrumb-->
        </div>
        <!--end::Page title-->
    </div>
</div>
<!--begin::Post-->
<div class="post d-flex flex-column-fluid mt-0">
    <!--begin::Container-->
    <div class="container">
        <!--begin::Pricing card-->
        <div class="card">
            <div class="card-header bg-secondary">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bolder text-dark">List Pengguna</span>
                </h3>
                <div class="card-toolbar">
                    @if ($level=="admin")
                    <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#store" class="btn btn-sm btn-primary"><i class="bi bi-plus-lg me-1"></i> Tambah</a>
                    @endif
                </div>
            </div>
            <!--begin::Card body-->
            <div class="card-body p-lg-5">
                <table id="datatable" class="table table-striped table-row-bordered gy-4 gs-7 border rounded">
                    <thead>
                        <tr class="fw-bolder bg-secondary fs-6 text-gray-800 px-7">
                            <th width="7%" class="align-middle">No</th>
                            <th class="align-middle text-center">Opsi</th>
                            <th class="align-middle text-center">Nama</th>
                            <th class="align-middle text-center">Email</th>
                            <th class="align-middle text-center">Username</th>
                            <th class="align-middle text-center">Level</th>
                            <th class="align-middle text-center">Ket</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($datas as $data)
                        @php
                            if ($data->status=="Aktif") {
                                $warna = "success";
                                $value = "0";
                                $icon = 'check';
                            }else{
                                $warna = "danger";
                                $value = "1";
                                $icon = 'x';
                            }

                            if($level=="user"){
                                $display="none";
                            }else{
                                $display="";
                            }
                        @endphp
                            <tr>
                                <td class="align-middle">{{ $loop->iteration }}</td>
                                <td class="align-middle">
                                    <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#update-status-{{ $data->id }}" class="btn btn-icon btn-sm btn-outline btn-outline-{{ $warna }} text-hover-white" style="display: {{ $display }};">
                                        <i class="bi bi-{{ $icon }} text-{{ $warna }} fs-6" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Status {{ $data->status }}"></i>
                                    </a>
                                    <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#update-password-{{ $data->id }}" class="btn btn-icon btn-sm btn-outline btn-outline-primary text-hover-white">
                                        <i class="bi bi-lock text-primary fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Ubah Password"></i>
                                    </a>
                                    <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#update-{{ $data->id }}" class="btn btn-icon btn-sm btn-outline btn-outline-info text-hover-white" style="display: {{ $display }};">
                                        <i class="bi bi-pencil text-info fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Ubah Data"></i>
                                    </a>
                                    <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#delete-{{ $data->id }}" class="btn btn-icon btn-sm btn-outline btn-outline-danger text-hover-white" style="display: {{ $display }};">
                                        <i class="bi bi-trash text-danger fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Hapus Data"></i>
                                    </a>
                                </td>
                                <td class="align-middle">{{ strtoupper($data->name) }}</td>
                                <td class="align-middle">{{ $data->email }}</td>
                                <td class="align-middle">{{ $data->username }}</td>
                                <td class="align-middle text-center">{{ $data->level }}<br></td>
                                <td class="align-middle text-end">
                                    Diinput: {{ date('d-m-Y',strtotime($data->created_at)) }}<br>
                                    Diedit: {{ date('d-m-Y',strtotime($data->updated_at)) }}
                                </td>
                            </tr>
                            @include('admin.pengguna.item.modal-update')
                            @include('admin.pengguna.item.modal-update-status')
                            @include('admin.pengguna.item.modal-update-password')
                            @include('admin.pengguna.item.modal-delete')
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@include('admin.pengguna.item.modal-store')
@endsection
@section('js')
<script src="https://code.jquery.com/jquery-3.5.1.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/dataTables.bootstrap5.min.js"></script>

<script>
    $(document).ready(function () {
        $('#datatable').DataTable({
            // "lengthMenu": [ [25, 50, 100, -1], [25, 50, 100, "All"] ],
            // "iDisplayLength": 25
        });
    });    
</script>
@endsection