@php
    use App\Models\Perangkat;
    use App\Models\Surat;
@endphp
@extends('admin.layouts.master')
@section('css')
<link href="https://cdn.datatables.net/1.13.1/css/dataTables.bootstrap5.min.css" rel="stylesheet" type="text/css" />
<link href="{{ asset('assets/fileinput/css/fileinput.css') }}" media="all" rel="stylesheet" type="text/css"/>
<link href="{{ asset('assets/fileinput/themes/explorer-fas/theme.css') }}" media="all" rel="stylesheet" type="text/css"/>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/baguettebox.js/1.10.0/baguetteBox.min.css"/>
@endsection
@section('content')
<!--begin::Toolbar-->
<div class="toolbar mt-2" id="kt_toolbar">
    <!--begin::Container-->
    <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
        <!--begin::Page title-->
        <div data-kt-swapper="true" data-kt-swapper-mode="prepend" data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}" class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
            <!--begin::Title-->
            <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1">{{ $tittle }}</h1>
            <!--end::Title-->
            <!--begin::Separator-->
            <span class="h-20px border-gray-300 border-start mx-4"></span>
            <!--end::Separator-->
            <!--begin::Breadcrumb-->
            <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-7 my-1">
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted">
                    <a href="{{ route('admin-dashboard') }}" class="text-muted text-hover-primary">Beranda</a>
                </li>
                <!--end::Item-->
                <!--begin::Item-->
                <li class="breadcrumb-item">
                    <span class="bullet bg-gray-300 w-5px h-2px"></span>
                </li>
                <!--end::Item-->
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted">{{ $tittle }}</li>
                <!--end::Item-->
            </ul>
            <!--end::Breadcrumb-->
        </div>
        <!--end::Page title-->
    </div>
</div>
<!--begin::Post-->
<div class="post d-flex flex-column-fluid mt-0">
    @if (count($errors) > 0)
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif
    <!--begin::Container-->
    @if ($jenis=='perintah')
    <div class="container">
        <!--begin::Pricing card-->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bolder text-dark">List {{ $tittle }}</span>
                </h3>
                <div class="card-toolbar">
                    <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#dl-store" class="btn btn-sm btn-primary"><i class="bi bi-plus-lg me-1"></i> Tambah</a>
                    {{-- <a href="{{ route('admin-surat-store',['jenis'=>$jenis]) }}" class="btn btn-sm btn-primary"><i class="bi bi-plus-lg me-1"></i> Tes RTF</a> --}}
                </div>
            </div>
            <!--begin::Card body-->
            <div class="card-body p-lg-5">
                <table id="datatable" class="table table-striped table-row-bordered gy-4 gs-7 border rounded">
                    <thead>
                        <tr class="fw-bolder bg-secondary fs-6 text-gray-800 px-7">
                            <th width="5%" class="align-middle">No</th>
                            <th class="align-middle text-center" width="15%">Opsi</th>
                            <th class="align-middle">No./Tanggal Surat</th>
                            <th class="align-middle">Pegawai TTD</th>
                            <th class="align-middle">Pegawai DL</th>
                            <th class="align-middle">Dasar DL</th>
                            <th class="align-middle">Tujuan DL</th>
                            <th class="align-middle">Tanggal DL</th>
                            <th class="align-middle">Waktu DL</th>
                            <th class="align-middle">Tempat DL</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($datas as $data)
                        @php
                            $no=1;
                            $pegawai_ttd = Perangkat::where('id', $data?->pegawai_dl_ttd)->first();
                            $pegawai_dl = json_decode($data?->pegawai_dl);
                        @endphp
                            <tr>
                                <td class="align-top">{{ $loop->iteration }}.</td>
                                <td class="align-top">
                                    <a href="{{ route('admin-surat-cetak-st',['jenis'=>$jenis,'id'=>$data->id]) }}" target="_blank" class="btn btn-icon btn-sm btn-outline btn-outline-warning text-hover-white mb-1">
                                        <i class="bi bi-printer text-warning fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Cetak Surat Tugas"></i>
                                    </a>
                                    <a href="{{ route('admin-surat-cetak-sppd',['jenis'=>$jenis,'id'=>$data->id]) }}" target="_blank" class="btn btn-icon btn-sm btn-outline btn-outline-primary text-hover-white mb-1">
                                        <i class="bi bi-printer text-primary fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Cetak SPPD Depan"></i>
                                    </a>
                                    <a href="{{ route('admin-surat-cetak-sppd-2',['jenis'=>$jenis,'id'=>$data->id]) }}" target="_blank" class="btn btn-icon btn-sm btn-outline btn-outline-dark text-hover-white mb-1">
                                        <i class="bi bi-printer text-dark fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Cetak SPPD Belakang"></i>
                                    </a><br>
                                    <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#dl-update-{{ $data?->id }}" class="btn btn-icon btn-sm btn-outline btn-outline-info text-hover-white mb-1">
                                        <i class="bi bi-pencil text-info fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Update"></i>
                                    </a>
                                    <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#dl-delete-{{ $data?->id }}" class="btn btn-icon btn-sm btn-outline btn-outline-danger text-hover-white mb-1">
                                        <i class="bi bi-trash text-danger fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Hapus"></i>
                                    </a>
                                </td>
                                <td class="align-top">
                                    <b>No. : </b>{{ $data?->nomor }}<br>
                                    <b>Tanggal : </b>{{ date('d-m-Y', strtotime($data?->tgl_surat)) }}
                                </td>
                                <td class="align-top">
                                    <b>Nama: </b>{{ $pegawai_ttd?->nama }}<br>
                                    <b>Jabatan: </b>{{ $pegawai_ttd?->jabatan }}
                                </td>
                                <td class="align-top">
                                    @php
                                    foreach ($pegawai_dl as $id){
                                        $dl = Perangkat::where('id', $id)->first();
                                        echo "<b>Pegawai : </b>".$dl->nama."<br>
                                        <b>Jabatan : </b>".$dl->jabatan."<br><br>";
                                    }
                                    @endphp
                                </td>
                                <td class="align-top">{{ $data?->dasar_surat_dl }}</td>
                                <td class="align-top">{{ $data?->tujuan_dl }}</td>
                                <td class="align-top">
                                    <b>Berangkat: </b>{{ date('d-m-Y',strtotime($data?->tgl_berangkat_dl)) }}
                                    <b>Pulang: </b>{{ date('d-m-Y',strtotime($data?->tgl_pulang_dl)) }}
                                </td>
                                <td class="align-top">{{ $data?->waktu_dl }} s/d Selesai</td>
                                <td class="align-top">{{ $data?->tempat_dl }}</td>
                            </tr>
                            @include('admin.surat.item.dl-modal-update')
                            @include('admin.surat.item.dl-modal-delete')
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    @elseif($jenis=='nota')
    <div class="container">
        <!--begin::Pricing card-->
        <div class="card">
            <div class="card-header bg-secondary">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bolder text-dark">List {{ $tittle }}</span>
                </h3>
                <div class="card-toolbar">
                    <a href="{{ route('admin-surat-tambah',['jenis'=>$jenis]) }}" class="btn btn-sm btn-primary"><i class="bi bi-plus-lg me-1"></i> Tambah</a>
                </div>
            </div>
            <!--begin::Card body-->
            <div class="card-body p-lg-5">
                <table id="datatable" class="table table-striped table-row-bordered gy-4 gs-7 border rounded">
                    <thead>
                        <tr class="fw-bolder bg-secondary fs-6 text-gray-800 px-7">
                            <th width="4%" class="align-middle">No</th>
                            <th class="align-middle text-center" width="15%">Opsi</th>
                            <th class="align-middle">Surat Tugas</th>
                            <th class="align-middle">Tanggal Nota Dinas</th>
                            <th class="align-middle">Penyelenggara</th>
                            <th class="align-middle">Acara/Kegiatan</th>
                            <th class="align-middle">Peserta</th>
                            <th class="align-middle">Hasil Kegiatan</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($notas as $nota)
                        @php
                            $jumlahkarakter=250;
                            $cetak = substr($nota->hasil, 0, $jumlahkarakter);

                            $st = Surat::where('id', $nota->surat_id)->first();
                        @endphp
                        <tr>
                            <td class="align-top">{{ $loop->iteration }}.</td>
                            <td class="align-top">
                                <a href="{{ route('admin-surat-cetak-nota',['jenis'=>$jenis,'id'=>$nota?->id]) }}" target="_blank" class="btn btn-icon btn-sm btn-outline btn-outline-primary text-hover-white mb-1">
                                    <i class="bi bi-printer text-primary fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Cetak Nota Dinas"></i>
                                </a>
                                <a href="{{ route('admin-surat-edit', ['jenis'=>$jenis,'id' => $nota?->id]) }}" class="btn btn-icon btn-sm btn-outline btn-outline-info text-hover-white mb-1">
                                    <i class="bi bi-pencil text-info fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Update"></i>
                                </a>
                                <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#nota-delete-{{ $nota?->id }}" class="btn btn-icon btn-sm btn-outline btn-outline-danger text-hover-white mb-1">
                                    <i class="bi bi-trash text-danger fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Hapus"></i>
                                </a>
                            </td>
                            <td class="align-top">
                                <b>No. </b>{{ $st?->nomor }}<br>
                                <b>Tanggal </b>{{ date('d-m-Y', strtotime($st?->tgl_surat)) }}<br>
                            </td>
                            <td class="align-top">
                                {{ date('d-m-Y', strtotime($nota?->tgl_nota)) }}<br>
                                @php
                                    $pegawai_dls = json_decode($st->pegawai_dl);
                                    if (!empty($pegawai_dls)) {
                                        $pegawai = Perangkat::where('id', $pegawai_dls[0])->first();
                                    } else {
                                        $pegawai = null;
                                    }
                                @endphp
                                <b>Pegawai </b>{{ $pegawai->nama }} - {{ $pegawai?->jabatan }}
                            </td>
                            <td class="align-top">{{ $nota?->penyelenggara }}</td>
                            <td class="align-top">{{ $nota?->acara }}</td>
                            <td class="align-top">{{ $nota?->peserta }}</td>
                            <td class="align-top"><?php echo $cetak;?></td>
                        </tr>
                        @include('admin.surat.item.dl-modal-delete')
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    @elseif($jenis=='kwitansi')
    <div class="container">
        <!--begin::Pricing card-->
        <div class="card">
            <div class="card-header bg-secondary">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bolder text-dark">List {{ $tittle }}</span>
                </h3>
                <div class="card-toolbar">
                    <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#dl-store" class="btn btn-sm btn-primary"><i class="bi bi-plus-lg me-1"></i> Tambah</a>
                    {{-- <a href="{{ route('admin-surat-store',['jenis'=>$jenis]) }}" class="btn btn-sm btn-primary"><i class="bi bi-plus-lg me-1"></i> Tes RTF</a> --}}
                </div>
            </div>
            <!--begin::Card body-->
            <div class="card-body p-lg-5">
                <table id="datatable" class="table table-striped table-row-bordered gy-4 gs-7 border rounded">
                    <thead>
                        <tr class="fw-bolder bg-secondary fs-6 text-gray-800 px-7">
                            <th width="4%" class="align-middle">No</th>
                            <th class="align-middle text-center" width="15%">Opsi</th>
                            <th class="align-middle">Surat Tugas</th>
                            <th class="align-middle">Tanggal Kwitansi</th>
                            <th class="align-middle">Uang harian</th>
                            <th class="align-middle">Transport</th>
                            <th class="align-middle">Penginapan</th>
                            <th class="align-middle">Representatif</th>
                            <th class="align-middle">Eviden</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($kwitansis as $kwitansi)
                        @php
                            
                            if (empty($kwitansi->eviden)) {
                                $eviden = "noimage.png";
                            } else {
                                $eviden = $kwitansi?->eviden;
                            }
                            $st = Surat::where('id', $kwitansi->surat_id)->first();
                        @endphp
                        <tr>
                            <td class="align-top">{{ $loop->iteration }}.</td>
                            <td class="align-top">
                                <a href="{{ route('admin-surat-cetak-kwitansi',['jenis'=>$jenis,'id'=>$kwitansi?->id]) }}" target="_blank" class="btn btn-icon btn-sm btn-outline btn-outline-primary text-hover-white mb-1">
                                    <i class="bi bi-printer text-primary fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Cetak Kwitansi Dinas"></i>
                                </a>
                                <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#kwitansi-update-{{ $kwitansi?->id }}" class="btn btn-icon btn-sm btn-outline btn-outline-info text-hover-white mb-1">
                                    <i class="bi bi-pencil text-info fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Update"></i>
                                </a>
                                <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#kwitansi-delete-{{ $kwitansi?->id }}" class="btn btn-icon btn-sm btn-outline btn-outline-danger text-hover-white mb-1">
                                    <i class="bi bi-trash text-danger fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Hapus"></i>
                                </a>
                            </td>
                            <td class="align-top">
                                <b>No. </b>{{ $st?->nomor }}<br>
                                <b>Tanggal </b>{{ date('d-m-Y', strtotime($st?->tgl_surat)) }}<br>    
                            </td>
                            <td class="align-top">
                                {{ date('d-m-Y', strtotime($kwitansi?->tgl_kwitansi)) }}<br>
                                @php
                                    $pegawai = Perangkat::where('id', $kwitansi->pegawai_id)->first();
                                @endphp
                                <b>Pegawai </b>{{ $pegawai->nama }} - {{ $pegawai?->jabatan }}
                            </td>
                            <td class="align-top">{{ $kwitansi?->uang_harian }}</td>
                            <td class="align-top">{{ $kwitansi?->transport }}</td>
                            <td class="align-top">{{ $kwitansi?->penginapan }}</td>
                            <td class="align-top">{{ $kwitansi?->representatif }}</td>
                            <td class="align-middle">
                                @if (!empty($kwitansi->eviden))
                                <section class="compact-gallery">
                                    @php
                                        $decode = json_decode($kwitansi->eviden);
                                    @endphp
                                    @foreach ($decode as $foto)
                                        <a class="lightbox" href="{{asset('assets/images/sppd/'.$foto.'')}}">
                                            <img class="img-fluid image" src="{{asset('assets/images/sppd/'.$foto.'')}}" width="50" height="50" style="object-fit:cover;">
                                        </a>
                                    @endforeach
                                </section>
                                @else
                                - 
                                @endif
                            </td>
                        </tr>
                        @include('admin.surat.item.dl-modal-update')
                        @include('admin.surat.item.dl-modal-delete')
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    @elseif($jenis=='masuk')
    <div class="container">
        <!--begin::Pricing card-->
        <div class="card">
            <div class="card-header bg-secondary">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bolder text-dark">List {{ $tittle }}</span>
                </h3>
                <div class="card-toolbar">
                    <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#masuk-store" class="btn btn-sm btn-primary"><i class="bi bi-plus-lg me-1"></i> Tambah</a>
                    {{-- <a href="{{ route('admin-surat-store',['jenis'=>$jenis]) }}" class="btn btn-sm btn-primary"><i class="bi bi-plus-lg me-1"></i> Tes RTF</a> --}}
                </div>
            </div>
            <!--begin::Card body-->
            <div class="card-body p-lg-5">
                <table id="datatable" class="table table-striped table-row-bordered gy-4 gs-7 border rounded">
                    <thead>
                        <tr class="fw-bolder bg-secondary fs-6 text-gray-800 px-7">
                            <th width="4%" class="align-middle">No</th>
                            <th class="align-middle text-center" width="15%">Opsi</th>
                            <th class="align-middle">Perihal</th>
                            <th class="align-middle">No/Tgl Surat</th>
                            <th class="align-middle">Tgl. Terima</th>
                            <th class="align-middle">Asal Surat</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($datas as $data)
                        @php
                            
                            if (empty($data?->file)) {
                                $file = "noimage.png";
                            } else {
                                $file = $data?->file;
                            }
                        @endphp
                        <tr>
                            <td class="align-top">{{ $loop->iteration }}.</td>
                            <td class="align-top">
                                <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#view-file-{{ $data?->id }}" class="btn btn-icon btn-sm btn-outline btn-outline-primary text-hover-white mb-1">
                                    <i class="bi bi-files text-primary fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Lihat Dokumen"></i>
                                </a>
                                <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#masuk-update-{{ $data?->id }}" class="btn btn-icon btn-sm btn-outline btn-outline-info text-hover-white mb-1">
                                    <i class="bi bi-pencil text-info fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Update"></i>
                                </a>
                                <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#dl-delete-{{ $data?->id }}" class="btn btn-icon btn-sm btn-outline btn-outline-danger text-hover-white mb-1">
                                    <i class="bi bi-trash text-danger fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Hapus"></i>
                                </a>
                            </td>
                            <td class="align-top">{{ $data?->perihal }}</td>
                            <td class="align-top">
                                <b>No. </b>{{ $data?->nomor }}<br>
                                <b>Tanggal </b>{{ date('d-m-Y', strtotime($data?->tgl_surat)) }}<br>    
                            </td>
                            <td class="align-top">{{ date('d-m-Y', strtotime($data?->tgl_terima)) }}</td>
                            <td class="align-top">{{ $data?->asal_surat }}</td>
                        </tr>
                        @include('admin.surat.item.modal-view-dok')
                        @include('admin.surat.item.dl-modal-update')
                        @include('admin.surat.item.dl-modal-delete')
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    @elseif($jenis=='keluar')
    <div class="container">
        <!--begin::Pricing card-->
        <div class="card">
            <div class="card-header bg-secondary">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bolder text-dark">List {{ $tittle }}</span>
                </h3>
                <div class="card-toolbar">
                    <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#keluar-store" class="btn btn-sm btn-primary"><i class="bi bi-plus-lg me-1"></i> Tambah</a>
                    {{-- <a href="{{ route('admin-surat-store',['jenis'=>$jenis]) }}" class="btn btn-sm btn-primary"><i class="bi bi-plus-lg me-1"></i> Tes RTF</a> --}}
                </div>
            </div>
            <!--begin::Card body-->
            <div class="card-body p-lg-5">
                <table id="datatable" class="table table-striped table-row-bordered gy-4 gs-7 border rounded">
                    <thead>
                        <tr class="fw-bolder bg-secondary fs-6 text-gray-800 px-7">
                            <th width="4%" class="align-middle">No</th>
                            <th class="align-middle text-center" width="15%">Opsi</th>
                            <th class="align-middle">Perihal</th>
                            <th class="align-middle">Nomor Surat</th>
                            <th class="align-middle">Tgl Surat</th>
                            <th class="align-middle">Penerima Surat</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($datas as $data)
                        @php
                            
                            if (empty($data?->file)) {
                                $file = "noimage.png";
                            } else {
                                $file = $data?->file;
                            }
                        @endphp
                        <tr>
                            <td class="align-top">{{ $loop->iteration }}.</td>
                            <td class="align-top">
                                <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#view-file-{{ $data?->id }}" class="btn btn-icon btn-sm btn-outline btn-outline-primary text-hover-white mb-1">
                                    <i class="bi bi-files text-primary fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Lihat Dokumen"></i>
                                </a>
                                <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#keluar-update-{{ $data?->id }}" class="btn btn-icon btn-sm btn-outline btn-outline-info text-hover-white mb-1">
                                    <i class="bi bi-pencil text-info fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Update"></i>
                                </a>
                                <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#dl-delete-{{ $data?->id }}" class="btn btn-icon btn-sm btn-outline btn-outline-danger text-hover-white mb-1">
                                    <i class="bi bi-trash text-danger fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Hapus"></i>
                                </a>
                            </td>
                            <td class="align-top">{{ $data?->perihal }}</td>
                            <td class="align-top">{{ $data?->nomor }}</td>
                            <td class="align-top">{{ date('d-m-Y', strtotime($data?->tgl_surat)) }}</td>
                            <td class="align-top">{{ $data?->tujuan_surat }}</td>
                        </tr>
                        @include('admin.surat.item.modal-view-dok')
                        @include('admin.surat.item.dl-modal-update')
                        @include('admin.surat.item.dl-modal-delete')
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    @else
    <div class="container">
        <!--begin::Pricing card-->
        <div class="card">
            <div class="card-header bg-secondary">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bolder text-dark">List {{ $tittle }}</span>
                </h3>
                <div class="card-toolbar">
                    {{-- <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#dl-store" class="btn btn-sm btn-primary"><i class="bi bi-plus-lg me-1"></i> Tambah</a> --}}
                    {{-- <a href="{{ route('admin-surat-store',['jenis'=>$jenis]) }}" class="btn btn-sm btn-primary"><i class="bi bi-plus-lg me-1"></i> Tes RTF</a> --}}
                </div>
            </div>
            <!--begin::Card body-->
            <div class="card-body p-lg-5">
                <img class="text-center" src="{{ asset('assets/images/coming-soon.avif') }}">
            </div>
        </div>
    </div>
    @endif
</div>
@include('admin.surat.item.dl-modal-store')

@endsection
@section('js')
<script src="https://code.jquery.com/jquery-3.5.1.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/dataTables.bootstrap5.min.js"></script>

<!-- Fileinput -->
<script src="{{ asset('assets/fileinput/js/plugins/piexif.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/js/plugins/sortable.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/js/fileinput.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/js/locales/fr.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/js/locales/es.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/themes/fas/theme.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/themes/explorer-fas/theme.js') }}" type="text/javascript"></script>

<script>
    $(document).ready(function () {
        $('#datatable').DataTable({
            // "lengthMenu": [ [25, 50, 100, -1], [25, 50, 100, "All"] ],
            // "iDisplayLength": 25
        });
    });

    $("#file-3").fileinput({
        theme: 'fas',
        showUpload: false,
        showCaption: true,
        dropZoneEnabled: false,
        browseClass: "btn btn-primary btn-md",
        allowedFileExtensions: ["jpg", "jpeg", "png","pdf"],
        previewFileIcon: "<i class='glyphicon glyphicon-king'></i>",
        overwriteInitial: true,
        initialPreviewAsData: true,
        maxFileSize: 2048,
        // mainClass: "input-group",
    });
  
</script>
<script>
    $("#file-4").fileinput({
        rtl: true,
        theme: 'fas',
        showUpload: false,
        showCaption: true,
        dropZoneEnabled: false,
        browseClass: "btn btn-primary btn-md",
        allowedFileExtensions: ["jpg", "jpeg", "png"],
        previewFileIcon: "<i class='glyphicon glyphicon-king'></i>",
        overwriteInitial: true,
        initialPreviewAsData: true,
        maxFileSize: 2048,
        mainClass: "input-group",
    });  
</script>
{{-- <script src="https://cdnjs.cloudflare.com/ajax/libs/baguettebox.js/1.10.0/baguetteBox.min.js"></script>
<script>
    baguetteBox.run('.compact-gallery', { animation: 'slideIn'});
</script> --}}
@endsection