@php
    use App\Models\Sosmed;
@endphp
@extends('admin.layouts.master')
@section('css')
<link href="https://cdn.datatables.net/1.13.1/css/dataTables.bootstrap5.min.css" rel="stylesheet" type="text/css" />
@endsection
@section('content')
<!--begin::Toolbar-->
<div class="toolbar mt-2" id="kt_toolbar">
    <!--begin::Container-->
    <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
        <!--begin::Page title-->
        <div data-kt-swapper="true" data-kt-swapper-mode="prepend" data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}" class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
            <!--begin::Title-->
            <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1">{{ $tittle }}</h1>
            <!--end::Title-->
            <!--begin::Separator-->
            <span class="h-20px border-gray-300 border-start mx-4"></span>
            <!--end::Separator-->
            <!--begin::Breadcrumb-->
            <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-7 my-1">
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted">
                    <a href="{{ route('admin-dashboard') }}" class="text-muted text-hover-primary">Beranda</a>
                </li>
                <li class="breadcrumb-item">
                    <span class="bullet bg-gray-300 w-5px h-2px"></span>
                </li>
                <li class="breadcrumb-item text-muted">{{ $tittle }}</li>
                <!--end::Item-->
            </ul>
            <!--end::Breadcrumb-->
        </div>
        <!--end::Page title-->
    </div>
</div>
<!--begin::Post-->
<div class="post d-flex flex-column-fluid mt-0">
    <!--begin::Container-->
    <div class="container">
        <!--begin::Pricing card-->
        @if (count($errors) > 0)
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
        @endif
        <div class="card mb-5 bg-warning">
            <div class="card-header">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bolder text-dark">Form Tambah {{ $tittle }}</span>
                </h3>
            </div>
            <form type="POST" action="{{ route('admin-visimisi-store') }}" method="post" enctype="multipart/form-data">
            @csrf
            <!--begin::Card body-->
            <div class="card-body p-lg-5">
                <div class="row">
                    <div class="col-md-2">
                        <div class="d-flex flex-column mb-7 fv-row">
                            <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                <span class="required">Pilih Jenis</span>
                            </label>
                            @php
                                $jeniss=['Visi','Misi'];
                            @endphp
                            <select name="jenis" id="jenis" class="form-control form-select{{ $errors->has('jenis') ? ' is-invalid' : '' }}">
                                @foreach ($jeniss as $jenis)
                                <option value="{{ $jenis }}">{{ $jenis }}</option>
                                @endforeach
                            </select>
                            @if($errors->has('jenis'))
                                <span class="invalid-feedback">{{ $errors->first('jenis') }}</span>
                            @endif
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="d-flex flex-column mb-7 fv-row">
                            <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                <span class="required">Periode Tahun</span>
                            </label>
                            <input type="text" name="periode" id="periode" class="form-control{{ $errors->has('periode') ? ' is-invalid' : '' }}" placeholder="Contoh: 2019-2024">
                            @if($errors->has('periode'))
                                <span class="invalid-feedback">{{ $errors->first('periode') }}</span>
                            @endif
                        </div>
                    </div>
                    <div class="col-md-8">
                        <div class="d-flex flex-column mb-7 fv-row">
                            <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                <span class="required">Poin Visi Misi</span>
                            </label>
                            <textarea name="isi_visimisi" id="isi_visimisi" class="form-control{{ $errors->has('isi_visimisi') ? ' is-invalid' : '' }}" placeholder="Masukan disini!" rows="2"></textarea>
                            @if($errors->has('isi_visimisi'))
                                <span class="invalid-feedback">{{ $errors->first('isi_visimisi') }}</span>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-footer text-end bg-warning">
                <button type="reset" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                <button type="submit" class="btn btn-primary">
                    <span class="indicator-label">Simpan</span>
                </button>
            </div>
            </form>
        </div>
        <div class="card">
            <div class="card-header bg-secondary">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bolder text-dark">List {{ $tittle }}</span>
                </h3>
                <div class="card-toolbar">
                    {{-- <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#store" class="btn btn-sm btn-primary"><i class="bi bi-plus-lg me-1"></i> Tambah</a> --}}
                </div>
            </div>
            <!--begin::Card body-->
            <div class="card-body p-lg-5">
                <table id="datatable" class="table table-striped table-row-bordered gy-4 gs-7 border rounded">
                    <thead>
                        <tr class="fw-bolder bg-secondary fs-6 text-gray-800 px-7">
                            <th width="7%" class="align-middle">No</th>
                            <th class="align-middle text-center" width="10%">Opsi</th>
                            <th class="align-middle text-center" width="15%">Periode</th>
                            <th class="align-middle text-center" width="15%">Jenis Visi Misi</th>
                            <th class="align-middle">Poin Visi Misi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($datas as $data)
                            <tr>
                                <td class="align-middle">{{ $loop->iteration }}</td>
                                <td class="align-middle">
                                    <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#update-{{ $data->id }}" class="btn btn-icon btn-sm btn-outline btn-outline-info text-hover-white">
                                        <i class="bi bi-pencil text-info fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Update"></i>
                                    </a>
                                    <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#delete-{{ $data->id }}" class="btn btn-icon btn-sm btn-outline btn-outline-danger text-hover-white">
                                        <i class="bi bi-trash text-danger fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Hapus"></i>
                                    </a>
                                </td>
                                <td class="align-middle text-center">{{ $data->periode }}</td>
                                <td class="align-middle text-center">{{ strtoupper($data->jenis) }}</td>
                                <td class="align-middle">{{ $data->isi_visimisi }}</td>
                            </tr>
                            @include('admin.visimisi.item.modal-update')
                            @include('admin.visimisi.item.modal-delete')
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@include('admin.sosmed.item.modal-store')
@endsection
@section('js')
<script src="https://code.jquery.com/jquery-3.5.1.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/dataTables.bootstrap5.min.js"></script>
<script>
    $(document).ready(function () {
        $('#datatable').DataTable({
            // "lengthMenu": [ [25, 50, 100, -1], [25, 50, 100, "All"] ],
            // "iDisplayLength": 25
        });
    });

    
</script>
@endsection