@php
    use App\Models\Informasipublik;
@endphp
@extends('guest.layouts.master')
@section('css')
@endsection
@section('content')
<div class="hero page-inner overlay"style="background-image: url({{ asset('guest/images/hero_bg_3.jpg') }})">
    <div class="container">
      <div class="row justify-content-center align-items-center">
        <div class="col-lg-9 text-center mt-5">
          <h1 class="heading" data-aos="fade-up">{{ $tittle }}</h1>
          <nav aria-label="breadcrumb"data-aos="fade-up"data-aos-delay="200">
            <ol class="breadcrumb text-center justify-content-center">
              <li class="breadcrumb-item"><a href="{{ route('beranda') }}">Beranda</a></li>
              <li class="breadcrumb-item active text-white-50"aria-current="page">{{ $tittle }}</li>
            </ol>
          </nav>
        </div>
      </div>
    </div>
</div>
<div class="section">
  <div class="container">
    <div class="row justify-content-between mb-5">
        <div class="col-lg-8 mb-5 mb-lg-0">
          <div class="row">
            <div class="col-md-12 mb-3">
              <div class="card">
                <div class="card-header">
                  <span class="card-title fs-3 text-dark">Dokumen {{ $kategori->nama }}</span>
                </div>
                <div class="card-body text-center">
                  <table class="table table-striped table-bordered">
                    <thead>
                      <tr>
                        <th class="taxt-bold" width="3%">No.</th>
                        <th class="taxt-bold" width="30%">Judul</th>
                        <th class="taxt-bold" width="5%">Tahun</th> 
                        <th class="taxt-bold" width="30%">Keterangan</th>
                        <th class="taxt-bold" width="">Dokumen</th>
                      </tr>
                    </thead>
                    <tbody>
                        @php
                        $informasipubliks = Informasipublik::where('id',$kategori->id)->orderBy('tahun', 'DESC')->paginate(5);
                        @endphp
                      @foreach ($informasipubliks as $data)    
                      <tr>
                        <td class="">{{ $loop->iteration }}</td>
                        <td class="">{{ $data->judul }}</td>
                        <td class="">{{ $data->tahun }}</td>
                        <td class="">{{ $data->deskripsi }}</td>
                        <td class=""><a href="{{ asset('assets/images/informasipublik/'.$data->file) }}" class="btn btn-sm btn-primary" target="_blank">Unduh</a></td>
                      </tr>
                      @endforeach
                    </tbody>
                  </table>
                  <nav>
                    {{$informasipubliks->links('guest.item.pagination')}}
                  </nav>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="col-lg-4">
          @include('guest.item.side.populer')
          @include('guest.item.side.galeri')
        </div>
    </div>
  </div>
</div>
@endsection
@section('js')
@endsection