<?php
    use App\Models\Informasipublik;
?>

<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="hero page-inner overlay"style="background-image: url(<?php echo e(asset('guest/images/hero_bg_3.jpg')); ?>)">
    <div class="container">
      <div class="row justify-content-center align-items-center">
        <div class="col-lg-9 text-center mt-5">
          <h1 class="heading" data-aos="fade-up"><?php echo e($tittle); ?></h1>
          <nav aria-label="breadcrumb"data-aos="fade-up"data-aos-delay="200">
            <ol class="breadcrumb text-center justify-content-center">
              <li class="breadcrumb-item"><a href="<?php echo e(route('beranda')); ?>">Beranda</a></li>
              <li class="breadcrumb-item active text-white-50"aria-current="page"><?php echo e($tittle); ?></li>
            </ol>
          </nav>
        </div>
      </div>
    </div>
</div>
<div class="section">
  <div class="container">
    <div class="row justify-content-between mb-5">
        <div class="col-lg-8 mb-5 mb-lg-0">
          <div class="row">
            <div class="col-md-12 mb-3">
              <div class="card">
                <div class="card-header">
                  <span class="card-title fs-3 text-dark">Dokumen <?php echo e($kategori->nama); ?></span>
                </div>
                <div class="card-body text-center">
                  <table class="table table-striped table-bordered">
                    <thead>
                      <tr>
                        <th class="taxt-bold" width="3%">No.</th>
                        <th class="taxt-bold" width="30%">Judul</th>
                        <th class="taxt-bold" width="5%">Tahun</th> 
                        <th class="taxt-bold" width="30%">Keterangan</th>
                        <th class="taxt-bold" width="">Dokumen</th>
                      </tr>
                    </thead>
                    <tbody>
                        <?php
                        $informasipubliks = Informasipublik::where('id',$kategori->id)->orderBy('tahun', 'DESC')->paginate(5);
                        ?>
                      <?php $__currentLoopData = $informasipubliks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>    
                      <tr>
                        <td class=""><?php echo e($loop->iteration); ?></td>
                        <td class=""><?php echo e($data->judul); ?></td>
                        <td class=""><?php echo e($data->tahun); ?></td>
                        <td class=""><?php echo e($data->deskripsi); ?></td>
                        <td class=""><a href="<?php echo e(asset('assets/images/informasipublik/'.$data->file)); ?>" class="btn btn-sm btn-primary" target="_blank">Unduh</a></td>
                      </tr>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                  </table>
                  <nav>
                    <?php echo e($informasipubliks->links('guest.item.pagination')); ?>

                  </nav>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="col-lg-4">
          <?php echo $__env->make('guest.item.side.populer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
          <?php echo $__env->make('guest.item.side.galeri', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('guest.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/pand6342/public_html/panyutran.desa.ids/resources/views/guest/informasipublik/index.blade.php ENDPATH**/ ?>