@extends('guest.layouts.master')
@section('css')
@endsection
@section('content')
<div class="hero page-inner overlay"style="background-image: url({{ asset('guest/images/hero_bg_3.jpg') }})">
    <div class="container">
      <div class="row justify-content-center align-items-center">
        <div class="col-lg-9 text-center mt-5">
          <h1 class="heading" data-aos="fade-up">{{ $tittle }}</h1>
          <nav aria-label="breadcrumb"data-aos="fade-up"data-aos-delay="200">
            <ol class="breadcrumb text-center justify-content-center">
              <li class="breadcrumb-item"><a href="{{ route('beranda') }}">Beranda</a></li>
              <li class="breadcrumb-item"><a href="{{ route('page',['alamat'=>'berita']) }}">{{ $tittle }}</a></li>
              <li class="breadcrumb-item active text-white-50"aria-current="page">{{ $data->judul }}</li>
            </ol>
          </nav>
        </div>
      </div>
    </div>
</div>
<div class="section">
  <div class="container">
    <div class="row justify-content-between mb-5">
      <div class="col-lg-7 mb-5 mb-lg-0">
        <h3>{{ $data?->judul }}</h3>
        <div class="specs d-flex mb-4">
          <span class="d-block d-flex align-items-center me-3">
            <span class="icon-user me-2"></span>
            <span class="caption">Admin</span>
          </span>
          <span class="d-block d-flex align-items-center me-3">
            <span class="icon-clock-o me-2"></span>
            <span class="caption">{{ date('d M Y h:s', strtotime($data?->tanggal)) }}</span>
          </span>
          <span class="d-block d-flex align-items-center">
            <span>Dibaca: {{ $data->baca }} Kali</span>
          </span>
        </div>
        <div class="img-about text-center">
          <img src="{{ asset('assets/images/berita/'.$data?->foto) }}" alt="Image" class="img-fluid" />
        </div><br>
        @if ($data->sumber==NULL)
        <div class="text-justify">
          <?php echo $data->isi_berita; ?>
        </div>
        @else
        <p class="text-bg"><b>Sumber: </b><u>{{ $data->sumber }}</u></p>
        <div class="text-justify">
          <?php echo $data->isi_berita; ?>
        </div>
        @endif
      </div>
      <div class="col-lg-4">
        @include('guest.item.side.populer')
        @include('guest.item.side.galeri')
      </div>
    </div>
  </div>
</div>
{{-- @include('guest.item.patner') --}}
@endsection
@section('js')
@endsection