<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });

// route GUEST=========================================================================
Route::get('/', 'App\Http\Controllers\GuestController@index')->name('beranda');
Route::get('/page/{alamat}', 'App\Http\Controllers\GuestController@page')->name('page');
Route::get('/page/berita', 'App\Http\Controllers\GuestController@berita')->name('berita');
Route::get('/berita/{slug}', 'App\Http\Controllers\GuestController@berita_detail')->name('berita-detail');
Route::get('/page/galeri', 'App\Http\Controllers\GuestController@galeri')->name('galeri');
Route::get('/galeri/{slug}', 'App\Http\Controllers\GuestController@galeri_detail')->name('galeri-detail');
// Route::get('/tentang', 'App\Http\Controllers\GuestController@tentang')->name('tentang');

Route::get('login', 'App\Http\Controllers\AuthController@index')->name('login');
Route::post('proses_login', 'App\Http\Controllers\AuthController@proses_login')->name('proses_login');
Route::get('logout', 'App\Http\Controllers\AuthController@logout')->name('logout');

Route::group(['middleware' => ['auth']], function () {
    Route::prefix('admin')->name('admin-')->middleware('cek_login:admin')->group(function () {
        Route::get('/', 'App\Http\Controllers\AdminController@index')->name('dashboard');

        Route::prefix('menu')->name('menu-')->group(function () {
            Route::get('/', 'App\Http\Controllers\Admin\MenuController@index')->name('index');
            Route::post('/store', 'App\Http\Controllers\Admin\MenuController@store')->name('store');
            Route::post('/update/{id}', 'App\Http\Controllers\Admin\MenuController@update')->name('update');
            Route::post('/status/{id}', 'App\Http\Controllers\Admin\MenuController@status')->name('status');
            Route::post('/delete/{id}', 'App\Http\Controllers\Admin\MenuController@delete')->name('delete');
        });
        Route::prefix('slider')->name('slider-')->group(function () {
            Route::get('/', 'App\Http\Controllers\Admin\SliderController@index')->name('index');
            Route::post('/store', 'App\Http\Controllers\Admin\SliderController@store')->name('store');
            Route::post('/update/{id}', 'App\Http\Controllers\Admin\SliderController@update')->name('update');
            Route::post('/status/{id}', 'App\Http\Controllers\Admin\SliderController@status')->name('status');
            Route::post('/delete/{id}', 'App\Http\Controllers\Admin\SliderController@delete')->name('delete');
        });

        Route::prefix('patner')->name('patner-')->group(function () {
            Route::get('/', 'App\Http\Controllers\Admin\PatnerController@index')->name('index');
            Route::post('/store', 'App\Http\Controllers\Admin\PatnerController@store')->name('store');
            Route::post('/update/{id}', 'App\Http\Controllers\Admin\PatnerController@update')->name('update');
            Route::post('/status/{id}', 'App\Http\Controllers\Admin\PatnerController@status')->name('status');
            Route::post('/delete/{id}', 'App\Http\Controllers\Admin\PatnerController@delete')->name('delete');
        });

        // TENTANG DESA========================================================================================
        Route::prefix('profil')->name('profil-')->group(function () {
            Route::get('/', 'App\Http\Controllers\Admin\ProfilController@index')->name('index');
            Route::get('/add', 'App\Http\Controllers\Admin\ProfilController@add')->name('add');
            Route::post('/store', 'App\Http\Controllers\Admin\ProfilController@store')->name('store');
            Route::get('/edit/{id}', 'App\Http\Controllers\Admin\ProfilController@edit')->name('edit');
            Route::post('/update', 'App\Http\Controllers\Admin\ProfilController@update')->name('update');
            Route::post('/status/{id}', 'App\Http\Controllers\Admin\ProfilController@status')->name('status');
            Route::post('/delete/{id}', 'App\Http\Controllers\Admin\ProfilController@delete')->name('delete');
        });

        Route::prefix('sejarah')->name('sejarah-')->group(function () {
            Route::get('/', 'App\Http\Controllers\Admin\SejarahController@index')->name('index');
            Route::post('/store', 'App\Http\Controllers\Admin\SejarahController@store')->name('store');
            Route::post('/update/{id}', 'App\Http\Controllers\Admin\SejarahController@update')->name('update');
            Route::post('/delete/{id}', 'App\Http\Controllers\Admin\SejarahController@delete')->name('delete');
        });

        Route::prefix('sotk')->name('sotk-')->group(function () {
            Route::get('/sotk', 'App\Http\Controllers\Admin\ProfilController@sotk')->name('sotk');
            Route::post('/sotk/store', 'App\Http\Controllers\Admin\ProfilController@store_sotk')->name('store-sotk');
            Route::post('/sotk/update/{id}', 'App\Http\Controllers\Admin\ProfilController@update_sotk')->name('update-sotk');
            Route::post('/sotk/delete/{id}', 'App\Http\Controllers\Admin\ProfilController@delete_sotk')->name('delete-sotk');
        });

        Route::prefix('visimisi')->name('visimisi-')->group(function () {
            Route::get('/', 'App\Http\Controllers\Admin\VisimisiController@index')->name('index');
            Route::post('/store', 'App\Http\Controllers\Admin\VisimisiController@store')->name('store');
            Route::post('/update/{id}', 'App\Http\Controllers\Admin\VisimisiController@update')->name('update');
            Route::post('/delete/{id}', 'App\Http\Controllers\Admin\VisimisiController@delete')->name('delete');
        });

        Route::prefix('sambutan')->name('sambutan-')->group(function () {
            Route::get('/', 'App\Http\Controllers\Admin\SambutanController@index')->name('index');
            Route::post('/store', 'App\Http\Controllers\Admin\SambutanController@store')->name('store');
            Route::post('/update/{id}', 'App\Http\Controllers\Admin\SambutanController@update')->name('update');
            Route::post('/delete/{id}', 'App\Http\Controllers\Admin\SambutanController@delete')->name('delete');
        });

        Route::prefix('program')->name('program-')->group(function () {
            Route::get('/', 'App\Http\Controllers\Admin\ProgramController@index')->name('index');
            Route::post('/store', 'App\Http\Controllers\Admin\ProgramController@store')->name('store');
            Route::post('/update/{id}', 'App\Http\Controllers\Admin\ProgramController@update')->name('update');
            Route::post('/delete/{id}', 'App\Http\Controllers\Admin\ProgramController@delete')->name('delete');
        });

        Route::prefix('wilayah')->name('wilayah-')->group(function () {
            Route::get('/', 'App\Http\Controllers\Admin\WilayahController@index')->name('index');
            Route::post('/store', 'App\Http\Controllers\Admin\WilayahController@store')->name('store');
            Route::post('/update/{id}', 'App\Http\Controllers\Admin\WilayahController@update')->name('update');
            Route::post('/delete/{id}', 'App\Http\Controllers\Admin\WilayahController@delete')->name('delete');
        });

        Route::prefix('potensi')->name('potensi-')->group(function () {
            Route::get('/', 'App\Http\Controllers\Admin\PotensiController@index')->name('index');
            Route::get('/add', 'App\Http\Controllers\Admin\PotensiController@add')->name('add');
            Route::post('/store', 'App\Http\Controllers\Admin\PotensiController@store')->name('store');
            Route::get('/edit/{id}', 'App\Http\Controllers\Admin\PotensiController@edit')->name('edit');
            Route::post('/update', 'App\Http\Controllers\Admin\PotensiController@update')->name('update');
            Route::post('/delete/{id}', 'App\Http\Controllers\Admin\PotensiController@delete')->name('delete');
        });

        Route::prefix('perangkat')->name('perangkat-')->group(function () {
            Route::get('/{kelompok}', 'App\Http\Controllers\Admin\PerangkatController@index')->name('index');
            Route::get('/{kelompok}/add', 'App\Http\Controllers\Admin\PerangkatController@add')->name('add');
            Route::post('/{kelompok}/store', 'App\Http\Controllers\Admin\PerangkatController@store')->name('store');
            Route::get('/{kelompok}/edit/{id}', 'App\Http\Controllers\Admin\PerangkatController@edit')->name('edit');
            Route::post('/{kelompok}/update', 'App\Http\Controllers\Admin\PerangkatController@update')->name('update');
            Route::post('/{kelompok}/delete/{id}', 'App\Http\Controllers\Admin\PerangkatController@delete')->name('delete');
        });


        // PUBLIKASI =============================================================================================
        Route::prefix('agenda')->name('agenda-')->group(function () {
            Route::get('/', 'App\Http\Controllers\Admin\AgendaController@index')->name('index');
            Route::post('/store', 'App\Http\Controllers\Admin\AgendaController@store')->name('store');
            Route::post('/update/{id}', 'App\Http\Controllers\Admin\AgendaController@update')->name('update');
            Route::post('/delete/{id}', 'App\Http\Controllers\Admin\AgendaController@delete')->name('delete');
        });

        Route::prefix('berita')->name('berita-')->group(function () {
            Route::get('/', 'App\Http\Controllers\Admin\BeritaController@index')->name('index');
            Route::get('/add', 'App\Http\Controllers\Admin\BeritaController@add')->name('add');
            Route::post('/store', 'App\Http\Controllers\Admin\BeritaController@store')->name('store');
            Route::get('/edit/{id}', 'App\Http\Controllers\Admin\BeritaController@edit')->name('edit');
            Route::post('/update', 'App\Http\Controllers\Admin\BeritaController@update')->name('update');
            Route::post('/delete/{id}', 'App\Http\Controllers\Admin\BeritaController@delete')->name('delete');
        });
        
        Route::prefix('galeri')->name('galeri-')->group(function () {
            Route::get('/', 'App\Http\Controllers\Admin\GaleriController@index')->name('index');
            Route::get('/add', 'App\Http\Controllers\Admin\GaleriController@add')->name('add');
            Route::post('/store', 'App\Http\Controllers\Admin\GaleriController@store')->name('store');
            Route::get('/edit/{id}', 'App\Http\Controllers\Admin\GaleriController@edit')->name('edit');
            Route::post('/update', 'App\Http\Controllers\Admin\GaleriController@update')->name('update');
            Route::post('/delete/{id}', 'App\Http\Controllers\Admin\GaleriController@delete')->name('delete');

            Route::get('/video', 'App\Http\Controllers\Admin\GaleriController@video')->name('video');
            Route::get('/add_video', 'App\Http\Controllers\Admin\GaleriController@add_video')->name('add_video');
            Route::post('/store_video', 'App\Http\Controllers\Admin\GaleriController@store_video')->name('store_video');
            Route::get('/edit_video/{id}', 'App\Http\Controllers\Admin\GaleriController@edit_video')->name('edit_video');
            Route::post('/update_video', 'App\Http\Controllers\Admin\GaleriController@update_video')->name('update_video');
            Route::post('/delete_video/{id}', 'App\Http\Controllers\Admin\GaleriController@delete_video')->name('delete_video');
        });

        Route::prefix('infopublik')->name('infopublik-')->group(function () {
            Route::get('/', 'App\Http\Controllers\Admin\InformasipublikController@index')->name('index');
            Route::post('/store', 'App\Http\Controllers\Admin\InformasipublikController@store')->name('store');
            Route::post('/update/{id}', 'App\Http\Controllers\Admin\InformasipublikController@update')->name('update');
            Route::post('/delete/{id}', 'App\Http\Controllers\Admin\InformasipublikController@delete')->name('delete');
            
            Route::post('/kategori/store', 'App\Http\Controllers\Admin\InformasipublikController@store_kategori')->name('store-kategori');
            Route::post('/kategori/kategori/update/{id}', 'App\Http\Controllers\Admin\InformasipublikController@update_kategori')->name('update-kategori');
            Route::post('/kategori/delete/{id}', 'App\Http\Controllers\Admin\InformasipublikController@delete_kategori')->name('delete-kategori');
        });

        Route::prefix('pengumuman')->name('pengumuman-')->group(function () {
            Route::get('/', 'App\Http\Controllers\Admin\PengumumanController@index')->name('index');
            Route::get('/add', 'App\Http\Controllers\Admin\PengumumanController@add')->name('add');
            Route::post('/store', 'App\Http\Controllers\Admin\PengumumanController@store')->name('store');
            Route::get('/edit/{id}', 'App\Http\Controllers\Admin\PengumumanController@edit')->name('edit');
            Route::post('/update', 'App\Http\Controllers\Admin\PengumumanController@update')->name('update');
            Route::post('/delete/{id}', 'App\Http\Controllers\Admin\PengumumanController@delete')->name('delete');
        });
        
        Route::prefix('sosmed')->name('sosmed-')->group(function () {
            Route::get('/', 'App\Http\Controllers\Admin\SosmedController@index')->name('index');
            Route::post('/store', 'App\Http\Controllers\Admin\SosmedController@store')->name('store');
            Route::post('/update/{id}', 'App\Http\Controllers\Admin\SosmedController@update')->name('update');
            Route::post('/delete/{id}', 'App\Http\Controllers\Admin\SosmedController@delete')->name('delete');
        });

        Route::prefix('tautan')->name('tautan-')->group(function () {
            Route::get('/tautan', 'App\Http\Controllers\Admin\SosmedController@tautan')->name('tautan');
            Route::post('/tautan/store', 'App\Http\Controllers\Admin\SosmedController@store_tautan')->name('store-tautan');
            Route::post('/tautan/update/{id}', 'App\Http\Controllers\Admin\SosmedController@update_tautan')->name('update-tautan');
            Route::post('/tautan/delete/{id}', 'App\Http\Controllers\Admin\SosmedController@delete_tautan')->name('delete-tautan');
        });
        
        // ADMINISTRASI DESA=====================================================================================
        Route::prefix('surat')->name('surat-')->group(function () {
            Route::get('/{jenis}', 'App\Http\Controllers\Admin\SuratController@index')->name('index');
            Route::get('/{jenis}/tambah', 'App\Http\Controllers\Admin\SuratController@tambah')->name('tambah');
            Route::get('/{jenis}/edit/{id}', 'App\Http\Controllers\Admin\SuratController@edit')->name('edit');
            Route::post('/{jenis}/store', 'App\Http\Controllers\Admin\SuratController@store')->name('store');
            Route::post('/{jenis}/update/{id}', 'App\Http\Controllers\Admin\SuratController@update')->name('update');
            Route::post('/{jenis}/delete/{id}', 'App\Http\Controllers\Admin\SuratController@delete')->name('delete');
            Route::get('/{jenis}/cetak-st/{id}', 'App\Http\Controllers\Admin\SuratController@cetak_st')->name('cetak-st');
            Route::get('/{jenis}/cetak-sppd/{id}', 'App\Http\Controllers\Admin\SuratController@cetak_sppd')->name('cetak-sppd');
            Route::get('/{jenis}/cetak-sppd-2/{id}', 'App\Http\Controllers\Admin\SuratController@cetak_sppd_2')->name('cetak-sppd-2');
            Route::get('/{jenis}/cetak-nota/{id}', 'App\Http\Controllers\Admin\SuratController@cetak_nota')->name('cetak-nota');
            Route::get('/{jenis}/cetak-kwitansi/{id}', 'App\Http\Controllers\Admin\SuratController@cetak_kwitansi')->name('cetak-kwitansi');
        });

        // KEPENDUDUKAN=====================================================================================
        Route::prefix('kependudukan')->name('kependudukan-')->group(function () {
            Route::get('/kk', 'App\Http\Controllers\Admin\Kependudukan\KkController@index')->name('kk');
            Route::get('/get-kks', 'App\Http\Controllers\Admin\Kependudukan\KkController@getKks')->name('get-kks');
            Route::post('/kk/store', 'App\Http\Controllers\Admin\Kependudukan\KkController@store')->name('kk-store');
            Route::get('/get-kk/{id}', 'App\Http\Controllers\Admin\Kependudukan\KkController@getKkid')->name('get-kk-id');
            Route::put('/kk/{id}', 'App\Http\Controllers\Admin\Kependudukan\KkController@update')->name('kk-update');
            Route::delete('/kk/{id}', 'App\Http\Controllers\Admin\Kependudukan\KkController@delete')->name('kk-delete');
            
            Route::get('/penduduk', 'App\Http\Controllers\Admin\Kependudukan\PendudukController@index')->name('penduduk');
            Route::get('/get-penduduk', 'App\Http\Controllers\Admin\Kependudukan\PendudukController@get_penduduk')->name('get-penduduk');
            Route::post('/penduduk/store', 'App\Http\Controllers\Admin\Kependudukan\PendudukController@store')->name('penduduk-store');
            Route::get('/get-penduduk/{id}', 'App\Http\Controllers\Admin\Kependudukan\PendudukController@getPendudukId')->name('get-penduduk-id');
            Route::put('/penduduk/{id}', 'App\Http\Controllers\Admin\Kependudukan\PendudukController@update')->name('penduduk-update');
            Route::delete('/penduduk/{id}', 'App\Http\Controllers\Admin\Kependudukan\PendudukController@delete')->name('penduduk-delete');


            Route::get('/lahir', 'App\Http\Controllers\Admin\Kependudukan\KkController@comingSoon')->name('lahir');
            Route::get('/meninggal', 'App\Http\Controllers\Admin\Kependudukan\KkController@comingSoon')->name('meninggal');
            Route::get('/pindah', 'App\Http\Controllers\Admin\Kependudukan\KkController@comingSoon')->name('pindah');
            Route::get('/datang', 'App\Http\Controllers\Admin\Kependudukan\KkController@comingSoon')->name('datang');

            // Route::get('/penduduk', 'App\Http\Controllers\Admin\KependudukanController@penduduk')->name('penduduk');
            // Route::get('/penduduk/add', 'App\Http\Controllers\Admin\KependudukanController@add_penduduk')->name('add-penduduk');
            // Route::get('/penduduk/edit/{id}', 'App\Http\Controllers\Admin\KependudukanController@edit_penduduk')->name('edit-penduduk');
            // Route::post('/penduduk/update', 'App\Http\Controllers\Admin\KependudukanController@update_penduduk')->name('update-penduduk');
            // Route::post('/penduduk/delete/{id}', 'App\Http\Controllers\Admin\KependudukanController@delete_penduduk')->name('delete-penduduk');

            // Route::get('/lahir', 'App\Http\Controllers\Admin\KependudukanController@lahir')->name('lahir');
            Route::get('/lahir/add', 'App\Http\Controllers\Admin\KependudukanController@add_lahir')->name('add-lahir');
            Route::post('/lahir/store', 'App\Http\Controllers\Admin\KependudukanController@store_lahir')->name('store-lahir');
            Route::get('/lahir/edit/{id}', 'App\Http\Controllers\Admin\KependudukanController@edit_lahir')->name('edit-lahir');
            Route::post('/lahir/update', 'App\Http\Controllers\Admin\KependudukanController@update_lahir')->name('update-lahir');
            Route::post('/lahir/delete/{id}', 'App\Http\Controllers\Admin\KependudukanController@delete_lahir')->name('delete-lahir');

            // Route::get('/meninggal', 'App\Http\Controllers\Admin\KependudukanController@meninggal')->name('meninggal');
            Route::get('/meninggal/add', 'App\Http\Controllers\Admin\KependudukanController@add_meninggal')->name('add-meninggal');
            Route::post('/meninggal/store', 'App\Http\Controllers\Admin\KependudukanController@store_meninggal')->name('store-meninggal');
            Route::get('/meninggal/edit/{id}', 'App\Http\Controllers\Admin\KependudukanController@edit_meninggal')->name('edit-meninggal');
            Route::post('/meninggal/update', 'App\Http\Controllers\Admin\KependudukanController@update_meninggal')->name('update-meninggal');
            Route::post('/meninggal/delete/{id}', 'App\Http\Controllers\Admin\KependudukanController@delete_meninggal')->name('delete-meninggal');

            // Route::get('/pindah', 'App\Http\Controllers\Admin\KependudukanController@pindah')->name('pindah');
            Route::get('/pindah/add', 'App\Http\Controllers\Admin\KependudukanController@add_pindah')->name('add-pindah');
            Route::post('/pindah/store', 'App\Http\Controllers\Admin\KependudukanController@store_pindah')->name('store-pindah');
            Route::get('/pindah/edit/{id}', 'App\Http\Controllers\Admin\KependudukanController@edit_pindah')->name('edit-pindah');
            Route::post('/pindah/update', 'App\Http\Controllers\Admin\KependudukanController@update_pindah')->name('update-pindah');
            Route::post('/pindah/delete/{id}', 'App\Http\Controllers\Admin\KependudukanController@delete_pindah')->name('delete-pindah');

            // Route::get('/datang', 'App\Http\Controllers\Admin\KependudukanController@datang')->name('datang');
            Route::get('/datang/add', 'App\Http\Controllers\Admin\KependudukanController@add_datang')->name('add-datang');
            Route::post('/datang/store', 'App\Http\Controllers\Admin\KependudukanController@store_datang')->name('store-datang');
            Route::get('/datang/edit/{id}', 'App\Http\Controllers\Admin\KependudukanController@edit_datang')->name('edit-datang');
            Route::post('/datang/update', 'App\Http\Controllers\Admin\KependudukanController@update_datang')->name('update-datang');
            Route::post('/datang/delete/{id}', 'App\Http\Controllers\Admin\KependudukanController@delete_datang')->name('delete-datang');
        });

        // PELAYANAN SURAT=====================================================================================
        // Route::prefix('refsk')->name('refsk-')->group(function () {
        //     Route::get('/', 'App\Http\Controllers\Admin\SK\RefSKController@index')->name('index');
        //     Route::get('/add', 'App\Http\Controllers\Admin\SK\RefSKController@add')->name('add');
        //     Route::post('/store', 'App\Http\Controllers\Admin\SK\RefSKController@store')->name('store');
        //     Route::get('/edit/{id}', 'App\Http\Controllers\Admin\SK\RefSKController@edit')->name('edit');
        //     Route::post('/update', 'App\Http\Controllers\Admin\SK\RefSKController@update')->name('update');
        //     Route::post('/delete/{id}', 'App\Http\Controllers\Admin\SK\RefSKController@delete')->name('delete');
        // });

        // Route::prefix('sk')->name('sk-')->group(function () {
        //     Route::get('/{slug}', 'App\Http\Controllers\Admin\SK\SkController@index')->name('index');
        //     Route::post('/{slug}/store', 'App\Http\Controllers\Admin\SK\SkController@store')->name('store');
        //     Route::post('/{slug}/update/{id}', 'App\Http\Controllers\Admin\SK\SkController@update')->name('update');
        //     Route::post('/{slug}/delete/{id}', 'App\Http\Controllers\Admin\SK\SkController@delete')->name('delete');
        // });

        Route::prefix('sk')->name('sk-')->group(function () {
            Route::prefix('domisili')->name('domisili-')->group(function () {
                Route::get('/', 'App\Http\Controllers\Admin\SK\DomisiliController@index')->name('index');
                Route::get('/get-data', 'App\Http\Controllers\Admin\SK\DomisiliController@getData')->name('get-data');
                Route::get('/cetak/{id}', 'App\Http\Controllers\Admin\SK\DomisiliController@cetak')->name('cetak');
                Route::post('/store', 'App\Http\Controllers\Admin\SK\DomisiliController@store')->name('store');
                Route::get('/get-data/{id}', 'App\Http\Controllers\Admin\SK\DomisiliController@getDataId')->name('get-data-id');
                Route::put('/update/{id}', 'App\Http\Controllers\Admin\SK\DomisiliController@update')->name('update');
                Route::delete('/delete/{id}', 'App\Http\Controllers\Admin\SK\DomisiliController@delete')->name('delete');

            });

            Route::prefix('kematian')->name('kematian-')->group(function () {
                Route::get('/', 'App\Http\Controllers\Admin\SK\KematianController@index')->name('index');
                Route::get('/get-data', 'App\Http\Controllers\Admin\SK\KematianController@getData')->name('get-data');
                Route::get('/cetak/{id}', 'App\Http\Controllers\Admin\SK\KematianController@cetak')->name('cetak');
                Route::post('/store', 'App\Http\Controllers\Admin\SK\KematianController@store')->name('store');
                Route::get('/get-data/{id}', 'App\Http\Controllers\Admin\SK\KematianController@getDataId')->name('get-data-id');
                Route::put('/update/{id}', 'App\Http\Controllers\Admin\SK\KematianController@update')->name('update');
                Route::delete('/delete/{id}', 'App\Http\Controllers\Admin\SK\KematianController@delete')->name('delete');

            });
        });

        Route::prefix('pengguna')->name('pengguna-')->group(function () {
            Route::get('/', 'App\Http\Controllers\Admin\PenggunaController@index')->name('index');
            Route::post('/store', 'App\Http\Controllers\Admin\PenggunaController@store')->name('store');
            Route::post('/update/{id}', 'App\Http\Controllers\Admin\PenggunaController@update')->name('update');
            Route::post('/update/status/{id}', 'App\Http\Controllers\Admin\PenggunaController@update_status')->name('update-status');
            Route::post('/update/password/{id}', 'App\Http\Controllers\Admin\PenggunaController@update_password')->name('update-password');
            Route::post('/delete/{id}', 'App\Http\Controllers\Admin\PenggunaController@delete')->name('delete');
        });

    });

    Route::prefix('user')->name('user-')->middleware('cek_login:user')->group(function () {
        Route::get('/', 'App\Http\Controllers\AdminController@index')->name('dashboard');

        Route::prefix('profil')->name('profil-')->group(function () {
            Route::get('/', 'App\Http\Controllers\Admin\ProfilController@index')->name('index');
            Route::get('/add', 'App\Http\Controllers\Admin\ProfilController@add')->name('add');
            Route::post('/store', 'App\Http\Controllers\Admin\ProfilController@store')->name('store');
            Route::post('/update/{id}', 'App\Http\Controllers\Admin\ProfilController@update')->name('update');
            Route::post('/delete/{id}', 'App\Http\Controllers\Admin\ProfilController@delete')->name('delete');
        });

        Route::prefix('kependudukan')->name('kependudukan-')->group(function () {
            Route::get('/kk', 'App\Http\Controllers\Admin\Kependudukan\KkController@index')->name('kk');
            Route::get('/get-kks', 'App\Http\Controllers\Admin\Kependudukan\KkController@getKks')->name('get-kks');
            Route::post('/kk/store', 'App\Http\Controllers\Admin\Kependudukan\KkController@store')->name('kk-store');
            Route::get('/get-kk/{id}', 'App\Http\Controllers\Admin\Kependudukan\KkController@getKkid')->name('get-kk-id');
            Route::put('/kk/{id}', 'App\Http\Controllers\Admin\Kependudukan\KkController@update')->name('kk-update');
            Route::delete('/kk/{id}', 'App\Http\Controllers\Admin\Kependudukan\KkController@delete')->name('kk-delete');
            
            Route::get('/penduduk', 'App\Http\Controllers\Admin\Kependudukan\PendudukController@index')->name('penduduk');
            Route::get('/get-penduduk', 'App\Http\Controllers\Admin\Kependudukan\PendudukController@get_penduduk')->name('get-penduduk');
            Route::post('/penduduk/store', 'App\Http\Controllers\Admin\Kependudukan\PendudukController@store')->name('penduduk-store');
            Route::get('/get-penduduk/{id}', 'App\Http\Controllers\Admin\Kependudukan\PendudukController@getPendudukId')->name('get-penduduk-id');
            Route::put('/penduduk/{id}', 'App\Http\Controllers\Admin\Kependudukan\PendudukController@update')->name('penduduk-update');
            Route::delete('/penduduk/{id}', 'App\Http\Controllers\Admin\Kependudukan\PendudukController@delete')->name('penduduk-delete');
            
            Route::get('/meninggal', 'App\Http\Controllers\Admin\Kependudukan\KkController@comingSoon')->name('meninggal');
            Route::get('/pindah', 'App\Http\Controllers\Admin\Kependudukan\KkController@comingSoon')->name('pindah');
            Route::get('/datang', 'App\Http\Controllers\Admin\Kependudukan\KkController@comingSoon')->name('datang');
        });

        Route::prefix('sk')->name('sk-')->group(function () {
            Route::prefix('domisili')->name('domisili-')->group(function () {
                Route::get('/', 'App\Http\Controllers\Admin\SK\DomisiliController@index')->name('index');
                Route::get('/get-data', 'App\Http\Controllers\Admin\SK\DomisiliController@getData')->name('get-data');
                Route::get('/cetak/{id}', 'App\Http\Controllers\Admin\SK\DomisiliController@cetak')->name('cetak');
                Route::post('/store', 'App\Http\Controllers\Admin\SK\DomisiliController@store')->name('store');
                Route::get('/get-data/{id}', 'App\Http\Controllers\Admin\SK\DomisiliController@getDataId')->name('get-data-id');
                Route::put('/update/{id}', 'App\Http\Controllers\Admin\SK\DomisiliController@update')->name('update');
                Route::delete('/delete/{id}', 'App\Http\Controllers\Admin\SK\DomisiliController@delete')->name('delete');

            });

            Route::prefix('kematian')->name('kematian-')->group(function () {
                Route::get('/', 'App\Http\Controllers\Admin\SK\KematianController@index')->name('index');
                Route::get('/get-data', 'App\Http\Controllers\Admin\SK\KematianController@getData')->name('get-data');
                Route::get('/cetak/{id}', 'App\Http\Controllers\Admin\SK\KematianController@cetak')->name('cetak');
                Route::post('/store', 'App\Http\Controllers\Admin\SK\KematianController@store')->name('store');
                Route::get('/get-data/{id}', 'App\Http\Controllers\Admin\SK\KematianController@getDataId')->name('get-data-id');
                Route::put('/update/{id}', 'App\Http\Controllers\Admin\SK\KematianController@update')->name('update');
                Route::delete('/delete/{id}', 'App\Http\Controllers\Admin\SK\KematianController@delete')->name('delete');

            });
        });

        Route::prefix('pengguna')->name('pengguna-')->group(function () {
            Route::get('/', 'App\Http\Controllers\Admin\PenggunaController@index')->name('index');
            Route::post('/store', 'App\Http\Controllers\Admin\PenggunaController@store')->name('store');
            Route::post('/update/{id}', 'App\Http\Controllers\Admin\PenggunaController@update')->name('update');
            Route::post('/update/status/{id}', 'App\Http\Controllers\Admin\PenggunaController@update_status')->name('update-status');
            Route::post('/update/password/{id}', 'App\Http\Controllers\Admin\PenggunaController@update_password')->name('update-password');
            Route::post('/delete/{id}', 'App\Http\Controllers\Admin\PenggunaController@delete')->name('delete');
        });
    });
});

