@extends('guest.layouts.master')
@section('css')
@endsection
@section('content')
<div class="hero page-inner overlay"style="background-image: url({{ asset('guest/images/hero_bg_3.jpg') }})">
    <div class="container">
      <div class="row justify-content-center align-items-center">
        <div class="col-lg-9 text-center mt-5">
          <h1 class="heading" data-aos="fade-up">{{ $tittle }}</h1>
          <nav aria-label="breadcrumb"data-aos="fade-up"data-aos-delay="200">
            <ol class="breadcrumb text-center justify-content-center">
              <li class="breadcrumb-item"><a href="{{ route('beranda') }}">Beranda</a></li>
              <li class="breadcrumb-item active text-white-50"aria-current="page">{{ $tittle }}</li>
            </ol>
          </nav>
        </div>
      </div>
    </div>
</div>
<div class="section">
  <div class="container">
    <div class="row justify-content-between mb-5">
      <div class="col-lg-7 mb-5 mb-lg-0">
        <h3>{{ $data?->judul }}</h3>
        <div class="specs d-flex mb-4">
          <span class="d-block d-flex align-items-center me-3">
            <span class="icon-user me-2"></span>
            <span class="caption">Admin</span>
          </span>
          <span class="d-block d-flex align-items-center">
            <span class="icon-clock-o me-2"></span>
            <span class="caption">{{ date('d M Y h:s', strtotime($data?->tanggal)) }}</span>
          </span>
        </div>
        <div class="img-about text-center">
          <img src="{{ asset('assets/images/berita/'.$data?->foto) }}" alt="Image" class="img-fluid" />
        </div><br>
        
        {{ strip_tags($data?->isi_berita) }}
      </div>
      <div class="col-lg-4">
        <h4>Berita Lainnya</h4><hr>
        @foreach ($beritas as $berita)
        @php
            $jumlahkarakter=90;
            $cetak = substr($data?->isi_berita, 0, $jumlahkarakter);
            $hasil = strip_tags($cetak);
        @endphp 
          <div class="d-flex feature-h">
            <span class="wrap-icon me-3" style="background-color: white;">
              {{-- <span> --}}
                <img src="{{ asset('assets/images/berita/'.$berita?->foto) }}" alt="Image" class="img-fluid" />
              {{-- </span> --}}
            </span>
            <div class="feature-text">
              <a href="{{ url('/berita/'.$berita?->slug_judul.'') }}"><span style="font-size: 15px;">{{ $berita?->judul }}</span></a>
              <p class="text-black-50">
                {{$hasil}}
              </p>
            </div>
          </div>
        @endforeach
      </div>
    </div>
  </div>
</div>
@include('guest.item.patner')
@endsection
@section('js')
@endsection